VERSION 5.00
Begin VB.Form fCairoDemo 
   BackColor       =   &H00FFFFFF&
   Caption         =   "Cairo-Tutorial"
   ClientHeight    =   7335
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   12045
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   ScaleHeight     =   7335
   ScaleWidth      =   12045
   StartUpPosition =   3  'Windows-Standard
   Begin VB.ComboBox cmbReload 
      Height          =   315
      ItemData        =   "fCairoDemo.frx":0000
      Left            =   270
      List            =   "fCairoDemo.frx":000D
      Style           =   2  'Dropdown-Liste
      TabIndex        =   0
      Top             =   60
      Width           =   3345
   End
   Begin CairoTutorial.ucCanvas ucCanvas1 
      Height          =   4515
      Left            =   0
      Top             =   450
      Width           =   8175
      _ExtentX        =   14420
      _ExtentY        =   7964
   End
   Begin VB.Label Label1 
      BackColor       =   &H00FFFFFF&
      Caption         =   "Up/Down-Keys change the desired Size,  Left/Right-Keys the Scroll-Position"
      Height          =   225
      Left            =   3720
      TabIndex        =   1
      Top             =   120
      Width           =   5685
   End
End
Attribute VB_Name = "fCairoDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private WithEvents sldIconIndex As cSimpleSlider
Attribute sldIconIndex.VB_VarHelpID = -1

Private DesiredSize As Long, CurIconIndex As Long

Private Const CarouselEntries& = 39


Private Sub Form_Load()
  Caption = "IconResource-Handling per Cairo.Imagelist"
  Me.ScaleMode = vbPixels
  
  Set sldIconIndex = New cSimpleSlider
  sldIconIndex.Init ucCanvas1.ControlPoints, 20, 400, 755, 28
  
  cmbReload.ListIndex = 2
End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
  If Cairo.ImageList.Count = 0 Then Exit Sub
  
  Select Case KeyCode
    Case vbKeyLeft:  KeyCode = 0: sldIconIndex.Value = CurIconIndex - 1
    Case vbKeyRight: KeyCode = 0: sldIconIndex.Value = CurIconIndex + 1
  End Select
  
  Draw ucCanvas1.CC
End Sub

Private Sub Form_Resize()
  If ScaleHeight - ucCanvas1.Top > 0 Then ucCanvas1.Move 0, ucCanvas1.Top, ScaleWidth, ScaleHeight - ucCanvas1.Top
End Sub

Private Sub cmbReload_Click()
Dim i&

  Select Case cmbReload.ListIndex
    Case 0: DesiredSize = 16
    Case 1: DesiredSize = 32
    Case 2: DesiredSize = 48
  End Select
  
  With Cairo.ImageList
    .RemoveAll

    'These first four entries only demonstrate, that you can use any file, which supports a
    'mask- or an alpha-channel as a potential IconResource. We add them (aside from the SVGs)
    'without the "DesiredSize"-Params, to demonstrate their better "high-res-potential" whilst scaling up
    .AddImage "some.svgz", App.Path & "\some.svgz", 100, 100 '<- let's give a hint to the resolution-independent SVG-...
    .AddImage "some.svg", App.Path & "\some.svg", 100, 100 '...Reader, regarding the Pixel-Dimensions we want to "pre-render"
    .AddImage "some.gif", App.Path & "\some.gif"
    .AddImage "some.png", App.Path & "\some.png"

    'better upscaling-quality can also be achieved by the Vista-Icons (which mostly contain Png-content too, besides
    'normal Icon-content)... and omitting the DesiredSize-Parameters, ensures the loading of this contained Png-Stream
    .AddIconFromFile "vista-icon png-content", App.Path & "\vista-alpha+png.ico"
    'now (by giving a Size-hint) we can also ensure the loading of "normal XP-AlphaIcon"-content (from the same *.ico-File)
    .AddIconFromFile "vista-icon normal-content", App.Path & "\vista-alpha+png.ico", DesiredSize, DesiredSize
    'and just for completeness, normal *.ico-File loading (from an "XP-Icon", which contains an AlphaChannel)
    .AddIconFromFile "normal XP-alpha-icon", App.Path & "\XP-alpha.ico", DesiredSize, DesiredSize


    'finally, this entry (as well as the following loop) demonstrates, how to load Windows-Icons
    'directly from resoure-binaries (at this occassion we perform also an "ImageList-Fillup-Stresstest" ;-)
    .AddIconFromResourceFile "explorer.exe at #111", "explorer.exe", 111, DesiredSize, DesiredSize
    
    'for a better overview on shell32-iconresources and their entry-number you can also look at:
    'http://www.glennslayden.com/code/win32/shell32-dll-icons
    For i = 1 To 331 'let's load entries 1-331 from shell32
      .AddIconFromResourceFile "shell32.dll at #" & i, "shell32.dll", i, DesiredSize, DesiredSize
    Next i
    
  End With
  
  sldIconIndex.Max = Cairo.ImageList.Count - 1
  
  Draw ucCanvas1.CC
End Sub

Private Sub sldIconIndex_ValueChanged(ByVal NewValue As Double)
  CurIconIndex = NewValue
  sldIconIndex.Caption = "ImagelistIndex: " & CurIconIndex
End Sub

Private Sub ucCanvas1_RefreshContents(CC As dhCairo.cCairoContext)
  Draw CC
End Sub

Private Sub Draw(CC As cCairoContext)
Dim ZoomC As Double, ZoomCHalf As Double, SizeHalf As Double 'used for the centered Icons
Dim i&, A As Double, AStep As Double, X As Double, Y As Double, FadeOutRatio As Double 'used for the carousel-icons
  
  'this time we "clean-up" our CC beforehand with a linear gradient-pattern instead of a solid white
  With Cairo.CreateLinearPattern(0, 0, 10, CC.Surface.Height)
    .AddColorStop 0, &H808080
    .AddColorStop 1, &HF0F0F0
    CC.Paint , .This
  End With
  
  
  CC.Save
    CC.TranslateDrawings 400, 200 'let's do our coord-calculations relative from a shifted center-point, that's easier...

    'Ok, let's try something like an "Image-Carousel" here ;-)
    AStep = 2 * Cairo.PI / CarouselEntries 'the Angle-Step calculation is easy to follow (since 2PI covers a "full circle")
    A = Cairo.PI / 2 - AStep / IIf(CarouselEntries Mod 2 = 1, 2, 1) 'Angle we will start from (the IIF deals with even or odd EntrieCounts)
    
    For i = CarouselEntries \ 2 To 0 Step -1 'we loop only over half the Entries, since we fill up in halfcircles symmetrically (drawing "Icon-pairs")
      
      'the following three lines are the standard-anglebased-construction for an Ellipse (Width=350, Height=85)
      A = A + AStep
      X = 350 * Cos(A)
      Y = 85 * Sin(A)

      FadeOutRatio = 1 - i / (CarouselEntries / 1.55)  'let's ensure the Icons "fade-off" at higher values of i (i counts from 0 to "icon-count per halfcircle")
      
      'fillup the halfcircle to the right ... the current Icon (the last one at "i = 0") is finally placed at the bottom-center
      If CurIconIndex + i < Cairo.ImageList.Count Then
        DrawCarouselIcon CC, CurIconIndex + i, -X, -Y, FadeOutRatio
      End If
      '...and the icon on the halfcircle to the left symmetrically
      If CurIconIndex - i >= 0 And i > 0 And ((CarouselEntries Mod 2 = 1) Or i <> CarouselEntries \ 2) Then
        DrawCarouselIcon CC, CurIconIndex - i, X, -Y, FadeOutRatio
      End If
    Next i
    
    
    'Since our circle above is done now, we can draw our current Image again upscaled (to a fixed Zoomsize),
    'and place it a little bit above the center of the carousel
    CC.TranslateDrawings 0, -66
    CC.SelectFont "Tahoma", 8.5, &H283838
    
    ZoomC = 96 '<-- this defines (in Pixels), how large the centered, current IconImage is rendered
    ZoomCHalf = ZoomC / 2

    'this will draw the upscaled version of the current Icon...
    CC.RenderSurfaceContent Cairo.ImageList.ItemByIndex(CurIconIndex), -ZoomCHalf, -ZoomCHalf, ZoomC, ZoomC
    
    '... + some info-text below...
    CC.DrawText -200, ZoomCHalf + 6, 400, 20, "Current Image: " & Cairo.ImageList.KeyByIndex(CurIconIndex) & _
                                              " (upscaled to " & ZoomC & "x" & ZoomC & ")", , vbCenter
  CC.Restore
  

  'finally we redraw our slider-control too
  sldIconIndex.Draw CC
  
  ucCanvas1.Refresh
End Sub

Private Sub DrawCarouselIcon(CC As cCairoContext, ByVal CurIdx As Long, ByVal X As Long, ByVal Y As Long, ByVal FadeOutRatio As Double)
Static CacheSrf As cCairoSurface, MaskSrf As cCairoSurface 'two statically defined "cache-objects"
Static mSize As Long ' and an additional static Var, which holds the last desired Size-Info

  If mSize <> DesiredSize Then  'in case the desired Iconsize differs from our last mSize value...
    'we store the Size in mSize and recreate (re-allocate) the Cache-Objects in the correct dimensions
    mSize = DesiredSize
    Set MaskSrf = Cairo.CreateSurface(mSize, mSize)
    Set CacheSrf = Cairo.CreateSurface(mSize, 2 * mSize) 'the Height of CacheSrf is twice as large (to hold also the reflection-effect)
    
    'now we prefill the MaskSurface with a linear Alpha-Pattern (used, to make the Reflection-Effect "weaker" at the bottom)
    'so, this second Surface is used as something like an "Alpha-channel-stamp" - and we achieve a better
    'perfomance, if we pre-draw and encapsulate the effect in a small, second surface,
    'since the plain Masking-Operation (the .MasSurface()-call farther below) works pretty fast -
    'it's more the preparation (and the filling) of a Mask-Surface which is a bit more expensive,
    'so we do it here only when the DesiredSize was changing (by interaction of the user on our combobox)
    With Cairo.CreateLinearPattern(0, 0, 0, mSize) 'a vertical Linear-Pattern
      .AddGaussianStops_ThreeColors 0, 0, 0, 0, 0.2, 0#, 0.92
      MaskSrf.CreateContext.Paint , .This
    End With
  End If
  
  
  With CacheSrf.CreateContext 'here we use VBs With-Statement to work with the CacheSrf-Context (we fill it up with the current Icon and the effect)
    
    'the following three lines ensure a "repaint" of the entire CacheSrf with "Black, fully transparent" (the default on Cairos-imagesurfaces)
    .Operator = CAIRO_OPERATOR_CLEAR 'set the Clear-Operator...
      .Paint '...paint the entire Surface with the current Operator...
    .Operator = CAIRO_OPERATOR_OVER 'and reset the current Operator to cairos default-operator

    'the next line renders a copy from the current Image-List-Index into CacheSrf
    'this is the normal, unreflected Icon-Image (as currently existing in our ImageList), placed in the upper half of CacheSrf
    .RenderSurfaceContent Cairo.ImageList.ItemByIndex(CurIdx), 0, 0, mSize, mSize
    
    
    'and now the lines, which ensure the reflection ...
    'CacheSrf was already sized twice as high (and now already contains our original Image in the upper half)
    
    .TranslateDrawings 0, 2 * mSize 'tell the CacheSrf-Context, to start our next operation at the bottom...
    .ScaleDrawings 1, -1 '<- also tell the context, that the drawing needs to be done "upwards" from there...

    .SetSourceSurface CacheSrf '<- this is a bit "funny", since we set our own pixelcontent (drawn so far) as the underlying *source* for the mask-operation
    .MaskSurface MaskSrf 'and finally this "stamps" the current source (set in the above line) with the (predefined) alpha-content in MaskSrf
  End With
  
  
  'finally the rendering of the current carousel-Icon which is now completed in CacheSrf onto our "outer CC" (the one which is "hosted" within our ucCanvas)
  If FadeOutRatio > 0 Then
    CC.Save

      CC.TranslateDrawings X, Y 'place the *outer contexts* coordssytem at our current (X,Y), which follows our "elliptic outline"
      
      'and now we make use of another feature of cairo (the ability, to wrap an existing surface with
      'an "intermediate" Surface-Pattern), to be able to transform such an "about to be placed SubSurface"
      'independently of the current Scale and Translate of the outer CC, since cairo-Patterns support
      'their own, relative Coord-System and their own Matrix-infos which we will make good use of now...
      
      'first we create a Matrix which later on will be placed as the new Pattern-Matrix
      Dim M As cCairoMatrix
      Set M = Cairo.CreateIdentityMatrix
      
      'this will shift the anchor-point of the wrapped pattern-surface (by default at the TopLeft-corner) into its center
      M.TranslateCoords CacheSrf.Width / 2, CacheSrf.Height / 2
      'and this ensures, that the Pattern will be rendered smaller (for Fadeout-Ratios < 1)
      M.ScaleCoords 1 / FadeOutRatio, 1 / FadeOutRatio
      
      'what remains is the short, intermediate wrapping of CacheSrf into a Pattern, the matrix-replace and the final CC.Paint-Call
      With CacheSrf.CreateSurfacePattern
        Set .Matrix = M 'replace the Pattern-matrix with our new one, created above (having the anchor-point at its center now)
 
        CC.SetSourcePattern .This 'set the Pattern as the current CC-Source
        
        'and Paint it onto the CC (one could use the FadeOut-Ratio also as an Alpha-Value here, so that not only the Icons Size fades out, but also its "visibility")
        CC.Paint 'FadeOutRatio
      End With
      
    CC.Restore
  End If
End Sub
